function escapeHtml(text) {
	return text
		.replace(/&/g, "&amp;")
		.replace(/</g, "&lt;")
		.replace(/>/g, "&gt;")
		.replace(/"/g, "&quot;")
		.replace(/'/g, "&#039;");
}

function elementsInsideRectElement(rectElement) {
	var x = rectElement.position().left;
	var y = rectElement.position().top;
	var width = rectElement.width();
	var height = rectElement.height();
	var result = new Array();
	var i = 0;
	console.log(x + ' ' + y + ' ' + width + ' ' + height);
	$('.row').each(function() {
		var elX = $(this).position().left;
		var elY = $(this).position().top;
		console.log(elX + " " + elY);
		if (elX > x && elY > y && elX < x + width && elY < height + y) {
			result[i++] = $(this);
		}
	});
	return result;
}

$(document).ready(function() {
	var enabled = true;
	if (enabled) {
		var focusedField = null;
		var previousSelectedDiv = null;
		var selectedDiv = null;
		var previousMousePosX = 0;
		var previousMousePosY = 0;
		window.ctrlDown = false;
		window.shiftDown = false;
		window.mouseDown = false;
		window.altDown = false;

		$(document).on('mousedown', '.row', function() {
			selectedDiv = $(this);
			window.mouseDown = true;
		});

		$(document).on('focus', 'input,textarea,button[type="submit"]', function() {
			focusedField = $(this);
			$(this).addClass('selectedInput');
		});

		$(document).on('click', 'input,textarea,button[type="submit"]', function(e) {
			e.stopPropagation();
		});
		$(document).on('mousedown', 'input,textarea,button[type="submit"]', function(e) {
			if (!window.shiftDown && !$(this).hasClass('selectedInput')) {
				$('.selectedInput').removeClass('selectedInput');
				$(this).addClass('selectedInput');
			}
		});

		$(document).on('click', function(e) {
			if (!window.shiftDown && !$(this).is('input,textarea'))
				$('input,textarea,button[type="submit"]').removeClass('selectedInput');
			console.log('html click');
		});

		$(document).on('blur', 'input,textarea', function() {
			focusedField = null;
		});

		$(document).mouseup(function() {
			previousSelectedDiv = selectedDiv;
			selectedDiv = null;
			window.mouseDown = false;
		});

		$(document).mousemove(function(e) {
			$('.selectedInput').each(function() {
				var selectedDiv = $(this).parent();
				if (!window.ctrlDown && !window.altDown && window.mouseDown && selectedDiv.length && previousMousePosX != 0 && previousMousePosY != 0) {
					var posDiffX = e.pageX - previousMousePosX;
					var posDiffY = e.pageY - previousMousePosY;
					if (selectedDiv.css('left') == 'auto')
						selectedDiv.css('left', 0);
					if (selectedDiv.css('top') == 'auto')
						selectedDiv.css('top', 0);
					selectedDiv.css('left', parseInt(selectedDiv.css('left').substr(0, selectedDiv.css('left').length - 2)) + parseInt(posDiffX));
					selectedDiv.css('top', parseInt(selectedDiv.css('top').substr(0, selectedDiv.css('top').length - 2)) + parseInt(posDiffY));
				} else {
					if (window.ctrlDown && window.mouseDown && selectedDiv) {
						var posDiffX = e.pageX - previousMousePosX;
						selectedDiv.find('input,textarea,button[type="submit"]').css('width', parseInt(selectedDiv.find('input,textarea,button[type="submit"]').css('width')) + parseInt(posDiffX));
					}
					if (window.altDown && window.mouseDown && selectedDiv) {
						var posDiffY = e.pageY - previousMousePosY;
						selectedDiv.find('input,textarea,button[type="submit"]').css('height', parseInt(selectedDiv.find('input,textarea,button[type="submit"]').css('height')) + parseInt(posDiffY));
					}
				}
			});
			previousMousePosX = e.pageX;
			previousMousePosY = e.pageY;
		});

		$(document).keydown(function(e) {
			if (e.altKey) {
				window.altDown = true;
			}
		});

		$(document).keyup(function(e) {
			if (e.keyCode == 18) {
				window.altDown = false;
			}
		});

		$(document).keydown(function(e) {
			if (e.ctrlKey) {
				window.ctrlDown = true;
			}
		});

		$(document).keyup(function(e) {
			if (e.keyCode == 17) {
				window.ctrlDown = false;
			}
		});

		$(document).keydown(function(e) {
			if (e.shiftKey) {
				window.shiftDown = true;
			}
		});

		$(document).keyup(function(e) {
			if (e.keyCode == 16) {
				window.shiftDown = false;
			}
		});

		$(document).keyup(function(e) {
			if (e.keyCode == 46) {
				$('.selectedInput').each(function() {
					$(this).parent('.row').remove();
				});
			}
		});

		$('#addTextField').mousedown(function(e) {
			if ($('.selectedInput').length) {
				$('.selectedInput').each(function() {
					var selectedDiv = $(this).parent();
					$('#dialog-form-element').append('\n\
					<div class="row" style="top: ' + (selectedDiv.position().top + 20) + 'px; left: ' + (selectedDiv.position().left) + 'px;">\
						<input class="selectedInput" type="text" name="test" style="width: ' + selectedDiv.css('width') + '" />\
					</div>\
					');
				});
			} else {
				console.log('test');
				$('#dialog-form-element').append('\n\
				<div class="row" style="top: ' + ($(window).scrollTop() + 50) + 'px; left: ' + ($(this).position().left) + 'px;">\
					<input type="text" name="test" style="" />\
				</div>\
				');
			}
		});

		$('#addTextArea').mousedown(function(e) {
			if ($('.selectedInput').length) {
				$('.selectedInput').each(function() {
					var selectedDiv = $(this).parent();
					$('#dialog-form-element').append('\n\
					<div class="row" style="height: auto; top: ' + (selectedDiv.position().top + 20) + 'px; left: ' + (selectedDiv.position().left) + 'px;">\
						<textarea class="selectedInput" name="test" style="width: ' + selectedDiv.css('width') + ' height: ' + selectedDiv.css('height') + '"> </textarea>\
					</div>\
					');
				});
			} else {
				$('#dialog-form-element').append('\n\
				<div class="row" style="height: auto; top: ' + ($(window).scrollTop() + 50) + 'px; left: ' + ($(this).position().left) + 'px;">\
					<textarea class="selectedInput" name="test" style=""> </textarea>\
				</div>\
				');
			}
		});

		$('#addSubmit').mousedown(function(e) {
			if ($('.selectedInput').length) {
				$('.selectedInput').each(function() {
					var selectedDiv = $(this).parent();
					$('#dialog-form-element').append('\n\
					<div class="row" style="height: auto; top: ' + (selectedDiv.position().top + 20) + 'px; left: ' + (selectedDiv.position().left) + 'px;">\
						<button style="" type="submit" value="confirm">Podpisz i wyślij</button>\
					</div>\
					');
				});
			} else {
				$('#dialog-form-element').append('\n\
				<div class="row" style="height: auto; top: ' + ($(window).scrollTop() + 50) + 'px; left: ' + ($(this).position().left) + 'px;">\
					<button style="" type="submit" value="confirm">Podpisz i wyślij</button>\
				</div>\
				');
			}
		});

		$('#addDraft').mousedown(function(e) {
			if ($('.selectedInput').length) {
				$('.selectedInput').each(function() {
					var selectedDiv = $(this).parent();
					$('#dialog-form-element').append('\n\
					<div class="row" style="height: auto; top: ' + (selectedDiv.position().top + 20) + 'px; left: ' + (selectedDiv.position().left) + 'px;">\
						<button style="" type="submit" value="saveDraft">Zapisz jako szkic</button>\
					</div>\
					');
				});
			} else {
				$('#dialog-form-element').append('\n\
				<div class="row" style="height: auto; top: ' + ($(window).scrollTop() + 50) + 'px; left: ' + ($(this).position().left) + 'px;">\
					<button style="" type="submit" value="saveDraft">Zapisz jako szkic</button>\
				</div>\
				');
			}
		});

		$('#addCheckBox').mousedown(function(e) {
			if ($('.selectedInput').length) {
				$('.selectedInput').each(function() {
					var selectedDiv = $(this).parent();
					$('#dialog-form-element').append('\n\
					<div class="row" style="height: auto; top: ' + (selectedDiv.position().top + 20) + 'px; left: ' + (selectedDiv.position().left) + 'px;">\
						<input type="checkbox">\
					</div>\
					');
				});
			} else {
				$('#dialog-form-element').append('\n\
				<div class="row" style="height: auto; top: ' + ($(window).scrollTop() + 50) + 'px; left: ' + ($(this).position().left) + 'px;">\
					<input type="checkbox">\
				</div>\
				');
			}
		});

		$('input[type="submit"]').click(function() {
			return false;
		});

		$('form').submit(function() {
			return false;
		});

		$('#generateModel').click(function() {
			var name = $('#formName').val();

			var modelString = 'class ' + name + ' extends DocumentFormModel {\n\
						function __construct($scenario = \'\') {\n\
							parent::__construct($scenario);\n\
							$this->formId = 1;\n\
						} ';
			//modelString += '';.css("background-image").replace("url(","").replace(")","");

			modelString += 'public $pageUrls = array(';

			var fieldId = 1;
			$('.ingameForm').children(':not(form)').each(function() {
				var url = $(this).css("background-image").replace("url(", "").replace(")", "");
				modelString += fieldId + '=>"' + (url.substring(url.lastIndexOf('/') + 1)) + '",';
				fieldId++;
			});

			modelString += '); ';

			modelString += 'public $fieldCoordinates = array(';

			fieldId = 1;
			$('.ingameForm form').children().each(function() {
				modelString += fieldId + '=>array("x"=> ' + $(this).position().left + ', "y"=>' + $(this).position().top + '),';
				fieldId++;
			});

			modelString += '); ';

			modelString += 'public $pageFields = array(';

			fieldId = 1;
			var pageId = 1;
			$('.ingameForm').children(':not(form)').each(function() {
				var elements = elementsInsideRectElement($(this));
				modelString += pageId + '=>array(';
				for (var a = 0; a < elements.length; a++) {
					modelString += fieldId + ',';
					fieldId++;
				}
				modelString += '), ';
				pageId++;
			});

			modelString += '); ';

			modelString += 'public $fieldType = array(';

			fieldId = 1;
			$('input[id!="formName"],textarea,button[type="submit"]').each(function() {
				var input = $(this);
				console.log(input.is('input[type="text"]'));
				if (input.is('input[type="text"]'))
					modelString += fieldId + '=>"textField",';
				else if (input.is('input[type="checkbox"]'))
					modelString += fieldId + '=>"checkbox",';
				else if (input.is('textarea'))
					modelString += fieldId + '=>"textarea",';
				else if (input.is('button'))
					modelString += fieldId + '=>"button",';
				fieldId++;
			});

			modelString += '); ';

			fieldId = 1;
			$('input[id!="formName"],textarea,button[type="submit"]').each(function() {
				modelString += '\n\
				public $field_' + fieldId + ';';
				fieldId++;
			});

			modelString += 'public function attributeLabels(){return array();}';
			modelString += 'public function rules(){return array(';

			fieldId = 1;
			$('input[id!="formName"],textarea').each(function() {
				modelString += '\n\
				array(\'field_' + fieldId + '\',\'required\'),';
				fieldId++;
			});

			modelString += ');}';
			modelString += '}';

			var myWindow = window.open('', 'asdf' + (new Date()).getTime());
			myWindow.document.write(modelString);

		});

		$('#generateView').click(function() {
			var viewString = '<div class="form ingameForm">';

			$('.ingameForm').children(':not(form)').each(function() {
				var temp = $(this).clone();
				viewString += temp.wrap("<span></span>").parent().html();
			});

			viewString += '<?php $form = $this->beginWidget(\'CActiveForm\',array(\'id\' => \'dialog-form-element\',\'htmlOptions\' => array(\'onsubmit\' => \'\')));?>';

			var fieldNumber = 1;
			$('.ingameForm form').children().each(function() {
				if ($(this).children().is('input') || $(this).children().is('textarea') || $(this).children().is('button[type="submit"]')) {
					var element = $(this).clone();
					var inputChild = element.children(':first').clone();

					viewString += '<div class="row" style="' + element.attr("style") + '">';
					if (inputChild.attr("type") == "text") {
						viewString += '<?php echo $form->textField($model, \'field_' + fieldNumber + '\', array(\'style\'=>\'' + inputChild.attr('style') + '\')) ?>';
						viewString += '<?php echo $form->error($model, \'field_' + fieldNumber + '\') ?>';
					} else if (inputChild.attr("type") == "checkbox") {
						viewString += '<?php echo $form->checkBox($model, \'field_' + fieldNumber + '\', array(\'style\'=>\'' + inputChild.attr('style') + '\')) ?>';
						viewString += '<?php echo $form->error($model, \'field_' + fieldNumber + '\') ?>';
					} else if (inputChild.is("textarea")) {
						viewString += '<?php echo $form->textarea($model, \'field_' + fieldNumber + '\', array(\'style\'=>\'' + inputChild.attr('style') + '\')) ?>';
						viewString += '<?php echo $form->error($model, \'field_' + fieldNumber + '\') ?>';
					} else if (inputChild.attr("type") == "submit") {
						viewString += '<button style="' + inputChild.attr('style') + '" type="submit" value="' + inputChild.attr('value') + '">' + inputChild.text() + '</button>';
					}
					viewString += '</div>';
					fieldNumber++;
				}
			});

			viewString += '<?php $this->endWidget(); ?></div>';
			var myWindow2 = window.open('', 'test' + (new Date()).getTime());
			myWindow2.document.write(escapeHtml(viewString));
		});
	}
});
